// Namespace
Checks = function(Client){
    // Checks if Block is in Core
    Client.CheckBlock = function(x, y, z) {
        const Blocks = Client.FindArea(Client);
        return Blocks.some(Block => Block.x === x && Block.y === y && Block.z === z);
    };

    // Function to manually check each block using write('block_place')
    Client.ManuallyCheckBlocksInCore = async function() {
        const Blocks = Client.FindArea();
        Blocks.forEach(Block => {
            Client.write('block_place', {
                location: { x: Block.x, y: Block.y, z: Block.z },
                direction: 1, // Direction the player is facing
                hand: 0, // Main hand
                cursorX: 0.5,
                cursorY: 0.5,
                cursorZ: 0.5,
                insideBlock: false
            });

            // Simulate closing the command block
            Client.write('block_dig', {
                status: 1, // Abort digging
                location: { x: Block.x, y: Block.y, z: Block.z },
                face: 1 // Face of the block being hit
            });
        });
    };
}

module.exports = Checks;