// Namespace
LocationMath = function(Client){
    // Returns Current Core location
    Client.GetCoreLocation = async function(){
        return await Client.CurrentCorePosition;
    }
    // Increases Core location by one and checks if at max capacity
    Client.IncreaseCoreLocation = async function(){
        Client.CurrentCorePosition++;
        if(Client.CurrentCorePosition > (Client.CoreSize.x * Client.CoreSize.y * Client.CoreSize.z)){
            Client.ResetCoreLocation();
        }
    }

    // Resets Core location too one and waits a Tick
    Client.ResetCoreLocation = async function(){
        Client.CurrentCorePosition = 0;
        Client.Sleep(60);
    }
}

module.exports = LocationMath;