/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.api.app;

import com.mrcrayfish.device.api.app.Component;
import com.mrcrayfish.device.api.app.Layout;
import com.mrcrayfish.device.api.app.component.Text;
import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.util.GLHelper;
import com.mrcrayfish.device.util.GuiHelper;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.math.MathHelper;

public class ScrollableLayout
extends Layout {
    protected int placeholderColor = new Color(1.0f, 1.0f, 1.0f, 0.35f).getRGB();
    protected int scroll;
    private int visibleHeight;
    private int scrollSpeed = 5;

    public ScrollableLayout(int width, int height, int visibleHeight) {
        super(width, height);
        this.visibleHeight = visibleHeight;
    }

    public ScrollableLayout(int left, int top, int width, int height, int visibleHeight) {
        super(left, top, width, height);
        this.visibleHeight = visibleHeight;
    }

    @Override
    public void render(Laptop laptop, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        if (!this.visible) {
            return;
        }
        GLHelper.pushScissor(x, y, this.width, this.visibleHeight);
        super.render(laptop, mc, x, y - this.scroll, mouseX, mouseY, windowActive, partialTicks);
        GLHelper.popScissor();
    }

    @Override
    public void renderOverlay(Laptop laptop, Minecraft mc, int mouseX, int mouseY, boolean windowActive) {
        if (!this.visible) {
            return;
        }
        super.renderOverlay(laptop, mc, mouseX, mouseY, windowActive);
        if (this.height > this.visibleHeight) {
            int visibleScrollBarHeight = this.visibleHeight;
            int scrollBarHeight = Math.max(20, (int)((float)this.visibleHeight / (float)this.height * (float)visibleScrollBarHeight));
            float scrollPercentage = MathHelper.func_76131_a((float)((float)this.scroll / (float)(this.height - this.visibleHeight)), (float)0.0f, (float)1.0f);
            int scrollBarY = (int)((float)(visibleScrollBarHeight - scrollBarHeight) * scrollPercentage);
            int scrollY = this.yPosition + scrollBarY;
            Gui.func_73734_a((int)(this.xPosition + this.width - 5), (int)scrollY, (int)(this.xPosition + this.width - 2), (int)(scrollY + scrollBarHeight), (int)this.placeholderColor);
        }
    }

    @Override
    public void updateComponents(int x, int y) {
        this.xPosition = x + this.left;
        this.yPosition = y + this.top;
        for (Component c : this.components) {
            c.updateComponents(x + this.left, y + this.top - this.scroll);
        }
    }

    @Override
    public void handleMouseScroll(int mouseX, int mouseY, boolean direction) {
        if (!this.visible || !this.enabled) {
            return;
        }
        if (GuiHelper.isMouseWithin(mouseX, mouseY, this.xPosition, this.yPosition, this.width, this.visibleHeight) && this.height > this.visibleHeight) {
            this.scroll += direction ? -this.scrollSpeed : this.scrollSpeed;
            if (this.scroll + this.visibleHeight > this.height) {
                this.scroll = this.height - this.visibleHeight;
            } else if (this.scroll < 0) {
                this.scroll = 0;
            }
            this.updateComponents(this.xPosition - this.left, this.yPosition - this.top);
        }
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (GuiHelper.isMouseWithin(mouseX, mouseY, this.xPosition, this.yPosition, this.width, this.visibleHeight)) {
            super.handleMouseClick(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    public void handleMouseRelease(int mouseX, int mouseY, int mouseButton) {
        if (GuiHelper.isMouseWithin(mouseX, mouseY, this.xPosition, this.yPosition, this.width, this.visibleHeight)) {
            super.handleMouseRelease(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    public void handleMouseDrag(int mouseX, int mouseY, int mouseButton) {
        if (GuiHelper.isMouseWithin(mouseX, mouseY, this.xPosition, this.yPosition, this.width, this.visibleHeight)) {
            super.handleMouseDrag(mouseX, mouseY, mouseButton);
        }
    }

    public static ScrollableLayout create(int left, int top, int width, int visibleHeight, String text) {
        Text t = new Text(text, 0, 0, width);
        ScrollableLayout layout = new ScrollableLayout(left, top, t.getWidth(), t.getHeight(), visibleHeight);
        layout.addComponent(t);
        return layout;
    }

    public void setScrollSpeed(int scrollSpeed) {
        this.scrollSpeed = scrollSpeed;
    }

    public void resetScroll() {
        this.scroll = 0;
        this.updateComponents(this.xPosition - this.left, this.yPosition - this.top);
    }
}

