/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs.system;

import com.jab125.version.VersionPredicate;
import com.jab125.version.VersionPredicateParser;
import com.mrcrayfish.device.MrCrayfishDeviceMod;
import com.mrcrayfish.device.api.app.IIcon;
import com.mrcrayfish.device.api.app.Icons;
import com.mrcrayfish.device.api.app.Layout;
import com.mrcrayfish.device.api.app.ScrollableLayout;
import com.mrcrayfish.device.api.app.component.Button;
import com.mrcrayfish.device.api.app.component.ItemList;
import com.mrcrayfish.device.api.app.component.Label;
import com.mrcrayfish.device.api.app.renderer.ListItemRenderer;
import com.mrcrayfish.device.api.utils.RenderUtil;
import com.mrcrayfish.device.programs.system.SystemApplication;
import com.mrcrayfish.device.util.Vulnerability;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.opengl.GL11;

public class VulnerabilityApp
extends SystemApplication {
    private long lastClick = 0L;
    private static final Color ITEM_BACKGROUND = Color.decode("0x9E9E9E");
    private static final Color ITEM_SELECTED = Color.decode("0x757575");
    private Layout mainMenu;
    int marginX = 10;
    int marginY = 10;
    int paddingY = 4;

    @Override
    public void init(@Nullable NBTTagCompound intent) {
        this.setCurrentLayout(this.createMenu());
    }

    private Layout createMenu() {
        this.mainMenu = new Layout(250, 105);
        final ItemList<Vulnerability> itemListResults = new ItemList<Vulnerability>(5, 5, 240, 5, true);
        itemListResults.setItems(MrCrayfishDeviceMod.getVulnerabilities());
        itemListResults.sortBy(Comparator.comparing(vulnerability -> -vulnerability.effectiveSeverity()));
        itemListResults.setListItemRenderer(new ListItemRenderer<Vulnerability>(18){

            @Override
            public void render(Vulnerability app, Gui gui, Minecraft mc, int x, int y, int width, int height, boolean selected) {
                Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)(selected ? ITEM_SELECTED.getRGB() : ITEM_BACKGROUND.getRGB()));
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                IIcon icon = VulnerabilityApp.this.getIconFor(app);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
                GlStateManager.func_179109_b((float)1.5f, (float)1.5f, (float)0.0f);
                GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.0f);
                icon.draw(mc, 0, 0);
                GlStateManager.func_179121_F();
                RenderUtil.drawStringClipped(app.title(), x + 20, y + 5, itemListResults.getWidth() - 22, Color.WHITE.getRGB(), false);
            }
        });
        itemListResults.setItemClickListener((info, index, mouseButton) -> {
            if (mouseButton == 0) {
                if (System.currentTimeMillis() - this.lastClick <= 200L) {
                    this.setCurrentLayout(this.createMenuFromVulnerability((Vulnerability)info));
                } else {
                    this.lastClick = System.currentTimeMillis();
                }
            }
        });
        this.mainMenu.addComponent(itemListResults);
        return this.mainMenu;
    }

    private IIcon getIconFor(Vulnerability app) {
        if (!app.affectsCurrentVersion()) {
            return Icons.WARNING_GRAY;
        }
        int severity = app.severity();
        if (severity < 3) {
            return Icons.WARNING;
        }
        if (severity < 6) {
            return Icons.FLASHED_WARNING;
        }
        if (severity <= 10) {
            return Icons.ERROR;
        }
        return Icons.WARNING;
    }

    private Layout createMenuFromVulnerability(Vulnerability vulnerability) {
        Layout layout = new Layout(250, 105);
        Button behindTheNews = new Button(5, 5, Icons.ARROW_LEFT);
        behindTheNews.setClickListener((__, ___, ____) -> this.setCurrentLayout(this.mainMenu));
        layout.addComponent(behindTheNews);
        Label l = new Label(vulnerability.title(), 5, 5 + behindTheNews.getHeight() + 2);
        l.setScale(1.25);
        layout.addComponent(l);
        layout.addComponent(new Label(vulnerability.reporter() == null ? "Unknown" : vulnerability.reporter(), 5, 18 + behindTheNews.getHeight() + 2));
        layout.addComponent(new Label("Affected Versions: " + this.re(vulnerability.affectedVersions()), 5, 28 + behindTheNews.getHeight() + 2));
        layout.addComponent(new Label("Fixed in: " + this.re(vulnerability.fixVersion(), true), 5, 38 + behindTheNews.getHeight() + 2));
        ScrollableLayout d = ScrollableLayout.create(5, 48 + behindTheNews.getHeight() + 2, layout.width - 5, 58 - (behindTheNews.getHeight() + 2), vulnerability.description() == null ? "No description provided" : vulnerability.description());
        layout.addComponent(d);
        return layout;
    }

    private String re(Collection<VersionPredicate> d, boolean e) {
        if (e && d.isEmpty()) {
            return "!(-\u221e,\u221e)";
        }
        ArrayList<String> l = new ArrayList<String>();
        for (VersionPredicate versionPredicate : d) {
            if (versionPredicate instanceof VersionPredicateParser.SingleVersionPredicate && versionPredicate.getInterval().getMin().equals(versionPredicate.getInterval().getMax())) {
                VersionPredicateParser.SingleVersionPredicate p = (VersionPredicateParser.SingleVersionPredicate)versionPredicate;
                l.add(p.getRefVersion().getFriendlyString());
                continue;
            }
            l.add(versionPredicate.getInterval().toString());
        }
        StringBuilder a = new StringBuilder();
        for (String versionInterval : l) {
            a.append(versionInterval).append(" ");
        }
        a.deleteCharAt(a.length() - 1);
        return a.toString();
    }

    private String re(Collection<VersionPredicate> d) {
        return this.re(d, false);
    }

    @Override
    public void load(NBTTagCompound tag) {
    }

    @Override
    public void save(NBTTagCompound tag) {
    }
}

