/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs.system.component;

import com.mrcrayfish.device.api.ApplicationManager;
import com.mrcrayfish.device.api.app.Component;
import com.mrcrayfish.device.api.app.Icons;
import com.mrcrayfish.device.api.app.Layout;
import com.mrcrayfish.device.api.app.component.Image;
import com.mrcrayfish.device.api.app.component.Label;
import com.mrcrayfish.device.api.utils.RenderUtil;
import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.object.AppInfo;
import com.mrcrayfish.device.programs.system.ApplicationAppStore;
import com.mrcrayfish.device.programs.system.object.AppEntry;
import com.mrcrayfish.device.programs.system.object.LocalEntry;
import com.mrcrayfish.device.programs.system.object.RemoteEntry;
import com.mrcrayfish.device.util.GuiHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;

public class AppGrid
extends Component {
    private int padding = 5;
    private int horizontalItems;
    private int verticalItems;
    private List<AppEntry> entries = new ArrayList<AppEntry>();
    private ApplicationAppStore store;
    private int itemWidth;
    private int itemHeight;
    private long lastClick = 0L;
    private int clickedIndex;
    private Layout container;

    public AppGrid(int left, int top, int horizontalItems, int verticalItems, ApplicationAppStore store) {
        super(left, top);
        this.horizontalItems = horizontalItems;
        this.verticalItems = verticalItems;
        this.store = store;
        this.itemWidth = (250 - this.padding * 2 - this.padding * (horizontalItems - 1)) / horizontalItems;
        this.itemHeight = 80;
    }

    @Override
    protected void init(Layout layout) {
        this.container = new Layout(0, 0, 250, this.horizontalItems * this.itemHeight + (this.horizontalItems + 1) * this.padding);
        int size = Math.min(this.entries.size(), this.verticalItems * this.horizontalItems);
        for (int i = 0; i < size; ++i) {
            AppEntry entry = this.entries.get(i);
            int itemX = this.left + i % this.horizontalItems * (this.itemWidth + this.padding) + this.padding;
            int itemY = this.top + i / this.horizontalItems * (this.itemHeight + this.padding) + this.padding;
            this.container.addComponent(this.generateAppTile(entry, itemX, itemY));
        }
        layout.addComponent(this.container);
    }

    @Override
    protected void render(Laptop laptop, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        int size = Math.min(this.entries.size(), this.verticalItems * this.horizontalItems);
        for (int i = 0; i < size; ++i) {
            int itemX = x + i % this.horizontalItems * (this.itemWidth + this.padding) + this.padding;
            int itemY = y + i / this.horizontalItems * (this.itemHeight + this.padding) + this.padding;
            if (!GuiHelper.isMouseWithin(mouseX, mouseY, itemX, itemY, this.itemWidth, this.itemHeight)) continue;
            Gui.func_73734_a((int)itemX, (int)itemY, (int)(itemX + this.itemWidth), (int)(itemY + this.itemHeight), (int)Color.GRAY.getRGB());
            Gui.func_73734_a((int)(itemX + 1), (int)(itemY + 1), (int)(itemX + this.itemWidth - 1), (int)(itemY + this.itemHeight - 1), (int)Laptop.getSystem().getSettings().getColorScheme().getItemBackgroundColor());
        }
    }

    @Override
    protected void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        int size = Math.min(this.entries.size(), this.verticalItems * this.horizontalItems);
        for (int i = 0; i < size; ++i) {
            int itemX = this.xPosition + i % this.horizontalItems * (this.itemWidth + this.padding) + this.padding;
            int itemY = this.yPosition + i / this.horizontalItems * (this.itemHeight + this.padding) + this.padding;
            if (!GuiHelper.isMouseWithin(mouseX, mouseY, itemX, itemY, this.itemWidth, this.itemHeight)) continue;
            if (System.currentTimeMillis() - this.lastClick <= 200L && this.clickedIndex == i) {
                this.lastClick = 0L;
                this.store.openApplication(this.entries.get(i));
                continue;
            }
            this.lastClick = System.currentTimeMillis();
            this.clickedIndex = i;
        }
    }

    public void addEntry(AppInfo info) {
        this.entries.add(new LocalEntry(info));
    }

    public void addEntry(AppEntry entry) {
        this.entries.add(this.adjustEntry(entry));
    }

    private AppEntry adjustEntry(AppEntry entry) {
        AppInfo info = ApplicationManager.getApplication(entry.getId());
        if (info != null) {
            return new LocalEntry(info);
        }
        return entry;
    }

    private Layout generateAppTile(AppEntry entry, int left, int top) {
        Layout layout = new Layout(left, top, this.itemWidth, this.itemHeight);
        int iconOffset = (this.itemWidth - 42) / 2;
        if (entry instanceof LocalEntry) {
            LocalEntry localEntry = (LocalEntry)entry;
            Image image = new Image(iconOffset, this.padding, 42, 42, localEntry.getInfo().getIconU(), localEntry.getInfo().getIconV(), 14, 14, 224, 224, Laptop.ICON_TEXTURES);
            layout.addComponent(image);
        } else if (entry instanceof RemoteEntry) {
            RemoteEntry remoteEntry = (RemoteEntry)entry;
            ResourceLocation resource = new ResourceLocation(remoteEntry.getId());
            Image image = new Image(iconOffset, this.padding, 42, 42, "https://raw.githubusercontent.com/MrCrayfish/DeviceMod-CertifiedApps/master/assets/" + resource.func_110624_b() + "/" + resource.func_110623_a() + "/icon.png");
            layout.addComponent(image);
        }
        String clippedName = RenderUtil.clipStringToWidth(entry.getName(), this.itemWidth - this.padding * 2);
        Label labelName = new Label(clippedName, this.itemWidth / 2, 50);
        labelName.setAlignment(2);
        layout.addComponent(labelName);
        String clippedAuthor = RenderUtil.clipStringToWidth(entry.getAuthor(), this.itemWidth - this.padding * 2);
        Label labelAuthor = new Label(clippedAuthor, this.itemWidth / 2, 62);
        labelAuthor.setAlignment(2);
        labelAuthor.setShadow(false);
        layout.addComponent(labelAuthor);
        if (this.store.certifiedApps.contains(entry)) {
            Image certifiedIcon = new Image(15, 38, Icons.VERIFIED);
            layout.addComponent(certifiedIcon);
        }
        if (entry instanceof LocalEntry) {
            AppInfo info = ((LocalEntry)entry).getInfo();
            if (Laptop.getSystem().getInstalledApplications().contains(info)) {
                Image installedIcon = new Image(this.itemWidth - 10 - 15, 38, Icons.CHECK);
                layout.addComponent(installedIcon);
            }
        }
        return layout;
    }

    public void reloadIcons() {
        if (this.container != null) {
            this.reloadIcons(this.container);
        }
    }

    private void reloadIcons(Layout layout) {
        layout.components.forEach(component -> {
            if (component instanceof Layout) {
                this.reloadIcons((Layout)((Object)component));
            } else if (component instanceof Image) {
                ((Image)((Object)component)).reload();
            }
        });
    }
}

