/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.item;

import java.util.List;
import javax.annotation.Nullable;
import mod.lucky.util.LuckyFunction;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLuckyBlock
extends ItemBlock {
    public ItemLuckyBlock(Block block) {
        super(block);
        this.func_77627_a(false);
    }

    public int getItemStackLimit(ItemStack itemStack) {
        int luckLevel = ItemLuckyBlock.getLuck(itemStack);
        String[] drops = ItemLuckyBlock.getDrops(itemStack);
        if (luckLevel == 0 && (drops == null || drops.length == 0)) {
            return 64;
        }
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        int luck = ItemLuckyBlock.getLuck(stack);
        String[] drops = ItemLuckyBlock.getDrops(stack);
        tooltip.add(I18n.func_74838_a((String)"item.luckyBlock.luck") + ": " + (luck == 0 ? TextFormatting.GOLD : (luck < 0 ? TextFormatting.RED : TextFormatting.GREEN + "+")) + String.valueOf(luck));
        if (drops != null && drops.length != 0) {
            tooltip.add(TextFormatting.GRAY + "" + TextFormatting.ITALIC + I18n.func_74838_a((String)"item.luckyBlock.customDrop"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack normalItemStack = new ItemStack((Item)this, 1, 0);
        items.add((Object)normalItemStack);
        if (((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.func_179223_d())).toString().equals("lucky:lucky_block")) {
            NBTTagCompound luckyTag = new NBTTagCompound();
            luckyTag.func_74768_a("Luck", 80);
            NBTTagCompound unluckyTag = new NBTTagCompound();
            unluckyTag.func_74768_a("Luck", -80);
            ItemStack luckyItemStack = new ItemStack((Item)this, 1, 0);
            luckyItemStack.func_77982_d(luckyTag);
            luckyItemStack.func_151001_c("Very Lucky Block");
            items.add((Object)luckyItemStack);
            ItemStack unluckyItemStack = new ItemStack((Item)this, 1, 0);
            unluckyItemStack.func_77982_d(unluckyTag);
            unluckyItemStack.func_151001_c("Unlucky Block");
            items.add((Object)unluckyItemStack);
        }
    }

    public static int getLuck(ItemStack itemStack) {
        try {
            return itemStack.func_77978_p().func_74762_e("Luck");
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    public static String[] getDrops(ItemStack itemStack) {
        try {
            return LuckyFunction.getStringArrayFromNBTTagList((NBTTagList)itemStack.func_77978_p().func_74781_a("Drops"));
        }
        catch (Exception e) {
            return null;
        }
    }
}

