/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.profiles;

import chanceCubes.profiles.GlobalProfileManager;
import chanceCubes.profiles.IProfile;
import chanceCubes.profiles.PlayerProfileManager;
import chanceCubes.profiles.triggers.ITrigger;
import chanceCubes.registry.global.GlobalCCRewardRegistry;
import chanceCubes.registry.player.PlayerCCRewardRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BasicProfile
implements IProfile {
    private Map<String, Map<ITrigger<?>, Boolean>> triggerStates = new HashMap();
    private String id;
    private String name;
    private String desc;
    private boolean anyTrigger = true;
    private StringBuilder descFull = new StringBuilder();
    private List<ITrigger<?>> triggers = new ArrayList();
    private List<String> rewardsToEnable = new ArrayList<String>();
    private List<String> rewardsToDisable = new ArrayList<String>();
    private List<IProfile> subProfiles = new ArrayList<IProfile>();
    private Map<String, Integer> chanceChanges = new HashMap<String, Integer>();
    private Map<String, Map<String, Object>> rewardSettings = new HashMap<String, Map<String, Object>>();

    public BasicProfile(String id, String name, String desc) {
        this.id = id;
        this.name = name;
        this.desc = desc;
    }

    public void setAnyTrigger(boolean anyTrigger) {
        this.anyTrigger = anyTrigger;
    }

    public BasicProfile addEnabledRewards(String ... rewards) {
        this.rewardsToEnable.addAll(Arrays.asList(rewards));
        return this;
    }

    public BasicProfile addDisabledRewards(String ... rewards) {
        this.rewardsToDisable.addAll(Arrays.asList(rewards));
        return this;
    }

    public BasicProfile addTriggers(ITrigger<?> ... triggers) {
        this.triggers.addAll(Arrays.asList(triggers));
        return this;
    }

    public BasicProfile addSubProfile(IProfile ... profiles) {
        this.subProfiles.addAll(Arrays.asList(profiles));
        return this;
    }

    public BasicProfile addRewardChanceChange(String rewardName, int newChance) {
        this.chanceChanges.put(rewardName, newChance);
        return this;
    }

    public BasicProfile addSettingsToReward(String reward, String key, Object value) {
        Map settings = this.rewardSettings.computeIfAbsent(reward, k -> new HashMap());
        settings.put(key, value);
        return this;
    }

    @Override
    public void onEnable(PlayerProfileManager playerProfileManager, String playerUUID) {
        PlayerCCRewardRegistry defaultPlayerRewards = GlobalCCRewardRegistry.DEFAULT.getPlayerRewardRegistry(playerUUID);
        PlayerCCRewardRegistry giantPlayerRewards = GlobalCCRewardRegistry.GIANT.getPlayerRewardRegistry(playerUUID);
        for (IProfile iProfile : this.subProfiles) {
            if (playerProfileManager.isProfileEnabled(iProfile)) continue;
            iProfile.onEnable(playerProfileManager, playerUUID);
        }
        for (String string : this.rewardsToDisable) {
            if (GlobalCCRewardRegistry.DEFAULT.isValidRewardName(string)) {
                defaultPlayerRewards.disableReward(string);
                continue;
            }
            if (!GlobalCCRewardRegistry.GIANT.isValidRewardName(string)) continue;
            giantPlayerRewards.disableReward(string);
        }
        for (String string : this.rewardsToEnable) {
            if (GlobalCCRewardRegistry.DEFAULT.isValidRewardName(string)) {
                defaultPlayerRewards.enableReward(string);
                continue;
            }
            if (!GlobalCCRewardRegistry.GIANT.isValidRewardName(string)) continue;
            giantPlayerRewards.enableReward(string);
        }
        for (Map.Entry entry : this.chanceChanges.entrySet()) {
            if (GlobalCCRewardRegistry.DEFAULT.isValidRewardName((String)entry.getKey())) {
                defaultPlayerRewards.setRewardChanceValue((String)entry.getKey(), (Integer)entry.getValue());
                continue;
            }
            if (!GlobalCCRewardRegistry.GIANT.isValidRewardName((String)entry.getKey())) continue;
            giantPlayerRewards.setRewardChanceValue((String)entry.getKey(), (Integer)entry.getValue());
        }
    }

    @Override
    public void onDisable(PlayerProfileManager playerProfileManager, String playerUUID) {
        if (playerProfileManager.isProfileEnabled(this)) {
            return;
        }
        PlayerCCRewardRegistry defaultPlayerRewards = GlobalCCRewardRegistry.DEFAULT.getPlayerRewardRegistry(playerUUID);
        PlayerCCRewardRegistry giantPlayerRewards = GlobalCCRewardRegistry.GIANT.getPlayerRewardRegistry(playerUUID);
        for (IProfile iProfile : this.subProfiles) {
            iProfile.onDisable(playerProfileManager, playerUUID);
        }
        for (String string : this.rewardsToDisable) {
            if (GlobalCCRewardRegistry.DEFAULT.isValidRewardName(string)) {
                defaultPlayerRewards.enableReward(string);
                continue;
            }
            if (!GlobalCCRewardRegistry.GIANT.isValidRewardName(string)) continue;
            giantPlayerRewards.enableReward(string);
        }
        for (String string : this.rewardsToEnable) {
            if (GlobalCCRewardRegistry.DEFAULT.isValidRewardName(string)) {
                defaultPlayerRewards.disableReward(string);
                continue;
            }
            if (!GlobalCCRewardRegistry.GIANT.isValidRewardName(string)) continue;
            giantPlayerRewards.disableReward(string);
        }
        for (Map.Entry entry : this.chanceChanges.entrySet()) {
            if (GlobalCCRewardRegistry.DEFAULT.isValidRewardName((String)entry.getKey())) {
                defaultPlayerRewards.setRewardChanceValue((String)entry.getKey(), (Integer)entry.getValue());
                continue;
            }
            if (!GlobalCCRewardRegistry.GIANT.isValidRewardName((String)entry.getKey())) continue;
            giantPlayerRewards.setRewardChanceValue((String)entry.getKey(), (Integer)entry.getValue());
        }
    }

    @Override
    public Map<String, Map<String, Object>> getRewardSettings() {
        return this.rewardSettings;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    public List<String> getRewardsToEnable() {
        return this.rewardsToEnable;
    }

    public List<String> getRewardsToDisable() {
        return this.rewardsToDisable;
    }

    public List<String> getChanceValueChanges() {
        ArrayList<String> toReturn = new ArrayList<String>();
        for (Map.Entry<String, Integer> change : this.chanceChanges.entrySet()) {
            toReturn.add(change.getKey() + " -> " + change.getValue());
        }
        return toReturn;
    }

    public List<IProfile> getSubProfiles() {
        return this.subProfiles;
    }

    @Override
    public String getDescLong() {
        if (this.descFull.length() == 0 && !this.desc.isEmpty()) {
            this.descFull.append(this.desc);
            this.descFull.append("\n");
            this.descFull.append("=== Rewards Enabled ===");
            this.descFull.append("\n");
            if (this.rewardsToEnable.size() == 0) {
                this.descFull.append("None\n");
            }
            for (String string : this.rewardsToEnable) {
                this.descFull.append(string);
                this.descFull.append("\n");
            }
            this.descFull.append("=== Rewards Disabled ===");
            this.descFull.append("\n");
            if (this.rewardsToDisable.size() == 0) {
                this.descFull.append("None\n");
            }
            for (String string : this.rewardsToDisable) {
                this.descFull.append(string);
                this.descFull.append("\n");
            }
            this.descFull.append("=== Triggers ===");
            this.descFull.append("\n");
            if (this.triggers.size() == 0) {
                this.descFull.append("None\n");
            }
            for (ITrigger iTrigger : this.triggers) {
                this.descFull.append(iTrigger.getTriggerDesc());
                this.descFull.append("\n");
            }
            this.descFull.append("=== Reward Chance Value Changes ===");
            this.descFull.append("\n");
            if (this.chanceChanges.size() == 0) {
                this.descFull.append("None\n");
            }
            for (Map.Entry entry : this.chanceChanges.entrySet()) {
                this.descFull.append((String)entry.getKey()).append(" -> ").append(entry.getValue());
                this.descFull.append("\n");
            }
            this.descFull.append("=== Sub Profiles ===");
            this.descFull.append("\n");
            if (this.subProfiles.size() == 0) {
                this.descFull.append("None\n");
            }
            for (IProfile iProfile : this.subProfiles) {
                this.descFull.append(iProfile.getName()).append(" (").append(iProfile.getID()).append(")");
                this.descFull.append("\n");
            }
        }
        return this.descFull.toString();
    }

    @Override
    public boolean isRewardEnabled(String reward) {
        if (this.rewardsToEnable.contains(reward)) {
            return true;
        }
        if (this.rewardsToDisable.contains(reward)) {
            return false;
        }
        for (IProfile subProf : this.subProfiles) {
            if (subProf.isRewardEnabled(reward)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<ITrigger<?>> getTriggers() {
        return this.triggers;
    }

    public Map<ITrigger<?>, Boolean> getDefaultTriggerMap() {
        HashMap triggerMap = new HashMap();
        for (ITrigger<?> trig : this.getTriggers()) {
            triggerMap.put(trig, false);
        }
        return triggerMap;
    }

    @Override
    public void setTriggerState(ITrigger<?> trigger, String playerUUID, boolean completed) {
        PlayerProfileManager playerProfileManager = GlobalProfileManager.getPlayerProfileManager(playerUUID);
        boolean enabled = playerProfileManager.isProfileEnabled(this);
        Map playerTriggerStates = this.triggerStates.computeIfAbsent(playerUUID, k -> this.getDefaultTriggerMap());
        playerTriggerStates.replace(trigger, completed);
        if (!enabled && this.anyTrigger && completed) {
            playerProfileManager.enableProfile(this);
        } else if (enabled && !this.anyTrigger && !completed) {
            playerProfileManager.disableProfile(this);
        } else {
            boolean shouldDisable = true;
            boolean shouldEnable = true;
            for (Boolean triggerCompeleted : playerTriggerStates.values()) {
                if (enabled && this.anyTrigger && triggerCompeleted.booleanValue()) {
                    shouldDisable = false;
                    break;
                }
                if (enabled || this.anyTrigger || triggerCompeleted.booleanValue()) continue;
                shouldEnable = false;
                break;
            }
            if (shouldEnable) {
                playerProfileManager.enableProfile(this);
            }
            if (shouldDisable) {
                playerProfileManager.disableProfile(this);
            }
        }
    }
}

