/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.sit;

import bl4ckscor3.mod.sit.Configuration;
import bl4ckscor3.mod.sit.EntitySit;
import bl4ckscor3.mod.sit.SitUtil;
import blusunrize.immersiveengineering.common.blocks.BlockIESlab;
import com.elytradev.architecture.common.block.BlockShape;
import com.elytradev.architecture.common.shape.Shape;
import com.elytradev.architecture.common.tile.TileShape;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="sit")
public class SitHandler {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getWorld().field_72995_K && event.getFace() == EnumFacing.UP && !SitUtil.isPlayerSitting(event.getEntityPlayer())) {
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            IBlockState state = world.func_180495_p(pos);
            Block block = world.func_180495_p(pos).func_177230_c();
            EntityPlayer player = event.getEntityPlayer();
            if (SitHandler.isValidBlock(world, pos, state, block) && SitHandler.isPlayerInRange(player, pos) && !SitUtil.isOccupied(world, pos) && player.func_184614_ca().func_190926_b()) {
                IBlockState stateAbove = world.func_180495_p(pos.func_177984_a());
                if (!stateAbove.func_177230_c().isAir(stateAbove, (IBlockAccess)world, pos.func_177984_a())) {
                    return;
                }
                if (block instanceof BlockSlab && (!state.func_177228_b().containsKey((Object)BlockSlab.field_176554_a) || state.func_177229_b((IProperty)BlockSlab.field_176554_a) != BlockSlab.EnumBlockHalf.BOTTOM)) {
                    return;
                }
                if (block instanceof BlockStairs && (!state.func_177228_b().containsKey((Object)BlockStairs.field_176308_b) || state.func_177229_b((IProperty)BlockStairs.field_176308_b) != BlockStairs.EnumHalf.BOTTOM)) {
                    return;
                }
                EntitySit sit = new EntitySit(world, pos);
                if (SitUtil.addSitEntity(world, pos, sit)) {
                    world.func_72838_d((Entity)sit);
                    player.func_184220_m((Entity)sit);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBreak(BlockEvent.BreakEvent event) {
        EntitySit entity;
        if (!event.getWorld().field_72995_K && (entity = SitUtil.getSitEntity(event.getWorld(), event.getPos())) != null && SitUtil.removeSitEntity(event.getWorld(), event.getPos())) {
            entity.func_70106_y();
        }
    }

    @SubscribeEvent
    public static void onEntityMount(EntityMountEvent event) {
        Entity entity;
        if (!event.getWorldObj().field_72995_K && event.isDismounting() && (entity = event.getEntityBeingMounted()) instanceof EntitySit && SitUtil.removeSitEntity(event.getWorldObj(), entity.func_180425_c())) {
            entity.func_70106_y();
        }
    }

    private static boolean isValidBlock(World world, BlockPos pos, IBlockState state, Block block) {
        boolean isValid;
        boolean bl = isValid = block instanceof BlockSlab || block instanceof BlockStairs || SitHandler.isModBlock(world, pos, block);
        if (!isValid && block instanceof BlockBed && !((state = world.func_180495_p(pos.func_177972_a(state.func_177229_b((IProperty)BlockBed.field_176472_a) == BlockBed.EnumPartType.HEAD ? ((EnumFacing)state.func_177229_b((IProperty)BlockBed.field_185512_D)).func_176734_d() : (EnumFacing)state.func_177229_b((IProperty)BlockBed.field_185512_D)))).func_177230_c() instanceof BlockBed)) {
            isValid = true;
        }
        return isValid;
    }

    private static boolean isModBlock(World world, BlockPos pos, Block block) {
        TileEntity te;
        if (Loader.isModLoaded((String)"immersiveengineering") && block instanceof BlockIESlab) {
            return true;
        }
        if (Loader.isModLoaded((String)"architecturecraft") && block instanceof BlockShape && (te = world.func_175625_s(pos)) instanceof TileShape) {
            return Arrays.asList(Shape.SLAB, Shape.STAIRS, Shape.STAIRS_INNER_CORNER, Shape.STAIRS_OUTER_CORNER).contains(((TileShape)te).getShape());
        }
        return false;
    }

    private static boolean isPlayerInRange(EntityPlayer player, BlockPos pos) {
        BlockPos playerPos = player.func_180425_c();
        if (Configuration.blockReachDistance == 0) {
            return playerPos.func_177956_o() - pos.func_177956_o() <= 1 && playerPos.func_177958_n() - pos.func_177958_n() == 0 && playerPos.func_177952_p() - pos.func_177952_p() == 0;
        }
        pos = pos.func_177963_a(0.5, 0.5, 0.5);
        AxisAlignedBB range = new AxisAlignedBB((double)(pos.func_177958_n() + Configuration.blockReachDistance), (double)(pos.func_177956_o() + Configuration.blockReachDistance), (double)(pos.func_177952_p() + Configuration.blockReachDistance), (double)(pos.func_177958_n() - Configuration.blockReachDistance), (double)(pos.func_177956_o() - Configuration.blockReachDistance), (double)(pos.func_177952_p() - Configuration.blockReachDistance));
        return range.field_72340_a <= (double)(playerPos = playerPos.func_177963_a(0.5, 0.5, 0.5)).func_177958_n() && range.field_72338_b <= (double)playerPos.func_177956_o() && range.field_72339_c <= (double)playerPos.func_177952_p() && range.field_72336_d >= (double)playerPos.func_177958_n() && range.field_72337_e >= (double)playerPos.func_177956_o() && range.field_72334_f >= (double)playerPos.func_177952_p();
    }
}

