/*
 * Decompiled with CFR 0.152.
 */
package superhb.arcademod.api.gui;

import java.awt.Color;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import superhb.arcademod.Arcade;
import superhb.arcademod.api.gui.GuiSoundButton;
import superhb.arcademod.client.ArcadeItems;
import superhb.arcademod.client.audio.ArcadeSounds;
import superhb.arcademod.client.tileentity.ArcadeLeaderboard;
import superhb.arcademod.client.tileentity.TileEntityArcade;
import superhb.arcademod.network.RewardMessage;
import superhb.arcademod.network.ServerCoinMessage;
import superhb.arcademod.util.ArcadePacketHandler;

public class GuiArcade
extends GuiScreen {
    public int tickCounter = 0;
    private boolean useTick = true;
    public boolean inMenu = true;
    public int menuOption = 0;
    public int menu = 0;
    public int startMenu = 0;
    public boolean useInternalMenu = true;
    public int textureWidth = 256;
    public int textureHeight = 256;
    private int guiLeft;
    private int guiTop;
    private int xSize = 0;
    private int ySize = 0;
    private ResourceLocation gui;
    private GuiButton insertCoin;
    private int buttonX = 0;
    private int buttonY = 0;
    public int buttonWidth;
    public int buttonHeight = 20;
    private int[] offset = new int[]{0, 0};
    private float scale = 1.0f;
    public int xScaled;
    public int yScaled;
    private int cost = 1;
    private boolean enoughCoins = true;
    public boolean canGetCoinBack = true;
    private TileEntityArcade tileEntity;
    private EntityPlayer player;
    private World world;
    private BlockPos pos;
    private static final ResourceLocation arrows = new ResourceLocation("arcademod:textures/gui/gui_arrows.png");

    public GuiArcade(World world, TileEntityArcade tileEntity, @Nullable BlockPos pos, EntityPlayer player) {
        this.pos = pos;
        this.world = world;
        this.tileEntity = tileEntity;
        this.player = player;
        if (this.useCoins()) {
            GuiArcade guiArcade = this;
            this.menu = !guiArcade.field_146297_k.func_71410_x().field_71439_g.func_184812_l_() ? -1 : this.startMenu;
        } else {
            this.menu = this.startMenu;
        }
        GuiArcade guiArcade = this;
        this.field_146289_q = guiArcade.field_146297_k.func_71410_x().field_71466_p;
        this.buttonWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"button.arcademod:insert.locale", (Object[])new Object[0])) + 6;
    }

    public void func_183500_a(int width, int height) {
        this.xSize = width;
        this.ySize = height;
    }

    public void setGuiSize(int width, int height, float scale) {
        this.xSize = width;
        this.ySize = height;
        this.scale = scale;
    }

    public void setGuiScale(float scale) {
        this.scale = scale;
    }

    public float getGuiScale() {
        return this.scale;
    }

    public void disableInternalMenu(boolean disable) {
        this.useInternalMenu = !disable;
    }

    public void setButtonPos(int x, int y) {
        this.buttonX = x;
        this.buttonY = y;
    }

    public void setOffset(int x, int y) {
        this.offset[0] = x;
        this.offset[1] = y;
    }

    public void setStartMenu(int startMenu) {
        this.startMenu = startMenu;
    }

    public int getStartMenu() {
        return this.startMenu;
    }

    @Deprecated
    public TileEntityArcade getTileEntity() {
        return this.tileEntity;
    }

    public void setTexture(ResourceLocation texture) {
        this.gui = texture;
    }

    public void setTexture(ResourceLocation texture, int width, int height) {
        this.gui = texture;
        this.textureWidth = width;
        this.textureHeight = height;
    }

    public void setButtonSize(int width, int height) {
        this.buttonWidth = width;
        this.buttonHeight = height;
    }

    public void isEnoughCoins(boolean enough) {
        this.enoughCoins = enough;
    }

    public boolean useCoins() {
        return !Arcade.disableCoins;
    }

    public void setCost(int cost) throws IndexOutOfBoundsException {
        if (cost > 64) {
            throw new IndexOutOfBoundsException("Max is 64");
        }
        this.cost = cost;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public void func_73876_c() {
        if (this.useTick) {
            ++this.tickCounter;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.xScaled = Math.round((float)(this.field_146294_l / 2) / this.scale);
        this.yScaled = Math.round((float)(this.field_146295_m / 2) / this.scale);
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)this.scale);
        this.field_146297_k.func_110434_K().func_110577_a(this.gui);
        GuiArcade.func_146110_a((int)(this.xScaled - this.xSize / 2), (int)(this.yScaled - this.ySize / 2), (float)0.0f, (float)0.0f, (int)this.xSize, (int)this.ySize, (float)this.textureWidth, (float)this.textureHeight);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.useInternalMenu) {
            int coinWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"button.arcademod:insert.locale", (Object[])new Object[0]) + "...");
            int neededSingWidth = this.field_146289_q.func_78256_a(this.cost + " " + I18n.func_135052_a((String)"text.arcademod:needed.locale", (Object[])new Object[0]));
            int neededPluralWidth = this.field_146289_q.func_78256_a(this.cost + " " + I18n.func_135052_a((String)"text.arcademod:needed_plural.locale", (Object[])new Object[0]));
            if (this.inMenu) {
                switch (this.menu) {
                    case -1: {
                        ((GuiButton)this.field_146292_n.get((int)0)).field_146124_l = true;
                        ((GuiButton)this.field_146292_n.get((int)0)).field_146125_m = true;
                        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"button.arcademod:insert.locale", (Object[])new Object[0]) + "...", this.xScaled - coinWidth / 2 + this.offset[0], this.yScaled + this.offset[1], 0xFFFFFF);
                        if (this.enoughCoins) break;
                        if (this.cost == 1) {
                            this.field_146289_q.func_78276_b(this.cost + " " + I18n.func_135052_a((String)"text.arcademod:needed.locale", (Object[])new Object[0]), this.xScaled - neededSingWidth / 2 + this.offset[0], this.yScaled + 10 + this.offset[1], 0xFF0000);
                            break;
                        }
                        this.field_146289_q.func_78276_b(this.cost + " " + I18n.func_135052_a((String)"text.arcademod:needed_plural.locale", (Object[])new Object[0]), this.xScaled - neededPluralWidth / 2 + this.offset[0], this.yScaled + 10 + this.offset[1], 0xFF0000);
                    }
                }
            }
            if (this.menu != -1 && this.useCoins()) {
                ((GuiButton)this.field_146292_n.get((int)0)).field_146124_l = false;
                ((GuiButton)this.field_146292_n.get((int)0)).field_146125_m = false;
            }
        }
    }

    public void drawLeftArrow(int x, int y) {
        this.drawLeftArrow(x, y, false);
    }

    public void drawRightArrow(int x, int y) {
        this.drawRightArrow(x, y, false);
    }

    public void drawUpArrow(int x, int y) {
        this.drawUpArrow(x, y, false);
    }

    public void drawDownArrow(int x, int y) {
        this.drawDownArrow(x, y, false);
    }

    public void drawLeftArrow(int x, int y, boolean bind) {
        if (bind) {
            this.field_146297_k.func_110434_K().func_110577_a(arrows);
        }
        GuiArcade.func_146110_a((int)x, (int)y, (float)7.0f, (float)0.0f, (int)7, (int)11, (float)128.0f, (float)128.0f);
    }

    public void drawRightArrow(int x, int y, boolean bind) {
        if (bind) {
            this.field_146297_k.func_110434_K().func_110577_a(arrows);
        }
        GuiArcade.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)7, (int)11, (float)128.0f, (float)128.0f);
    }

    public void drawUpArrow(int x, int y, boolean bind) {
        if (bind) {
            this.field_146297_k.func_110434_K().func_110577_a(arrows);
        }
        GuiArcade.func_146110_a((int)x, (int)y, (float)25.0f, (float)0.0f, (int)11, (int)7, (float)128.0f, (float)128.0f);
    }

    public void drawDownArrow(int x, int y, boolean bind) {
        if (bind) {
            this.field_146297_k.func_110434_K().func_110577_a(arrows);
        }
        GuiArcade.func_146110_a((int)x, (int)y, (float)14.0f, (float)0.0f, (int)11, (int)7, (float)128.0f, (float)128.0f);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = Math.round((float)(this.field_146294_l / 2) / this.scale) - this.xSize / 2;
        this.guiTop = Math.round((float)(this.field_146295_m / 2) / this.scale) - this.ySize / 2;
        if (this.useCoins()) {
            this.insertCoin = new GuiSoundButton(0, this.guiLeft + this.buttonX, this.guiTop + this.buttonY, this.buttonWidth, this.buttonHeight, this.scale, I18n.func_135052_a((String)"button.arcademod:insert.locale", (Object[])new Object[0]), ArcadeSounds.INSERT_COIN);
            this.field_146292_n.add(this.insertCoin);
        }
    }

    public void func_146281_b() {
    }

    @Deprecated
    public void updateLeaderboard(String name, int score, String difficulty) {
        boolean stopChecking = false;
        ArcadeLeaderboard[] temp = this.getLeaderboard();
        ArcadeLeaderboard[] leaderboard = this.getLeaderboard();
        int place = 11;
        this.tileEntity.saveLeaderboard(leaderboard);
    }

    public float[] colorToFloat(Color color) {
        float red = (float)Math.round((float)color.getRed() / 255.0f * 100.0f) / 100.0f;
        float green = (float)Math.round((float)color.getGreen() / 255.0f * 100.0f) / 100.0f;
        float blue = (float)Math.round((float)color.getBlue() / 255.0f * 100.0f) / 100.0f;
        return new float[]{red, green, blue};
    }

    public void glColor(Color color) {
        float red = (float)Math.round((float)color.getRed() / 255.0f * 100.0f) / 100.0f;
        float green = (float)Math.round((float)color.getGreen() / 255.0f * 100.0f) / 100.0f;
        float blue = (float)Math.round((float)color.getBlue() / 255.0f * 100.0f) / 100.0f;
        GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
    }

    @Deprecated
    public long map(long in, long inMin, long inMax, long outMin, long outMax) {
        return (in - inMin) * (outMax - outMin) / (inMax - inMin) + outMin;
    }

    public double rand(int min, int max) {
        return Math.random() * (double)(max - min) + (double)min;
    }

    @Deprecated
    public ArcadeLeaderboard[] getLeaderboard() {
        return this.tileEntity.getLeaderboard();
    }

    @Deprecated
    public ArcadeLeaderboard getHighscore() {
        return this.tileEntity.getLeaderboard()[0];
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l && button == this.insertCoin) {
            ArcadePacketHandler.INSTANCE.sendToServer((IMessage)new ServerCoinMessage(new ItemStack(ArcadeItems.COIN), this.cost));
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1 && this.canGetCoinBack && !this.field_146297_k.field_71439_g.func_184812_l_() && this.menu != -1) {
            this.giveReward(ArcadeItems.COIN, this.cost);
        }
        super.func_73869_a(typedChar, keyCode);
    }

    public boolean isKeyDown(int keyCode) {
        return Keyboard.isKeyDown((int)keyCode);
    }

    public void giveReward(ItemStack reward) {
        ArcadePacketHandler.INSTANCE.sendToServer((IMessage)new RewardMessage(reward));
    }

    public void giveReward(Item item, int amount) {
        ArcadePacketHandler.INSTANCE.sendToServer((IMessage)new RewardMessage(item, amount, 0));
    }

    public void giveReward(Item item, int amount, int meta) {
        ArcadePacketHandler.INSTANCE.sendToServer((IMessage)new RewardMessage(item, amount, meta));
    }

    public void giveReward(Item item, int amount, int meta, NBTTagCompound compound) {
        ArcadePacketHandler.INSTANCE.sendToServer((IMessage)new RewardMessage(item, amount, meta, compound));
    }

    public void checkMenuAfterGameOver() {
        if (this.useCoins()) {
            GuiArcade guiArcade = this;
            this.menu = !guiArcade.field_146297_k.func_71410_x().field_71439_g.func_184812_l_() ? -1 : this.startMenu;
        } else {
            this.menu = this.startMenu;
        }
    }
}

