/*
 * Decompiled with CFR 0.152.
 */
package superhb.arcademod.client.blocks;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import superhb.arcademod.Arcade;
import superhb.arcademod.client.ArcadeBlocks;
import superhb.arcademod.client.blocks.IBlockVariant;
import superhb.arcademod.client.tileentity.TileEntityArcade;
import superhb.arcademod.util.EnumGame;

public class BlockArcade
extends Block
implements IBlockVariant {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum GAME = PropertyEnum.func_177709_a((String)"game", EnumGame.class);

    public BlockArcade(Material material) {
        super(material);
        this.func_149711_c(1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)GAME, (Comparable)((Object)EnumGame.SNAKE)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityArcade();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_181623_g() {
        return false;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List drops = super.getDrops(world, pos, state, fortune);
        TileEntityArcade tile = world.func_175625_s(pos) instanceof TileEntityArcade ? (TileEntityArcade)world.func_175625_s(pos) : null;
        NBTTagCompound compound = new NBTTagCompound();
        ItemStack stack = new ItemStack((Block)this);
        compound.func_74768_a("Game", tile.getGameID());
        stack.func_77982_d(compound);
        if (tile != null) {
            drops.add(stack);
        }
        return drops;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                return new AxisAlignedBB(0.0625, 0.0, 0.0, 0.9375, 1.0, 0.875);
            }
            case SOUTH: {
                return new AxisAlignedBB(0.0625, 0.0, 0.125, 0.9375, 1.0, 1.0);
            }
            case WEST: {
                return new AxisAlignedBB(0.0, 0.0, 0.0625, 0.875, 1.0, 0.9375);
            }
            case EAST: {
                return new AxisAlignedBB(0.125, 0.0, 0.0625, 1.0, 1.0, 0.9375);
            }
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.9375, 0.75);
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        return state.func_185900_c((IBlockAccess)world, pos).func_186670_a(pos);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean par6) {
        Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.8125, 0.0, 1.0, 0.1875, 1.0));
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, 1.6875, 0.0, 1.0, 1.875, 0.875));
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, 1.0, 0.0, 1.0, 1.6875, 0.75));
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.8125, 0.8125));
                break;
            }
            case SOUTH: {
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, 1.6875, 0.125, 1.0, 1.875, 1.0));
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, 1.0, 0.25, 1.0, 1.6875, 1.0));
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.1875, 1.0, 0.8125, 1.0));
                break;
            }
            case WEST: {
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, 1.6875, 0.0, 0.875, 1.875, 1.0));
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, 1.0, 0.0, 0.75, 1.6875, 1.0));
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 0.8125, 0.8125, 1.0));
                break;
            }
            case EAST: {
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.125, 1.6875, 0.0, 1.0, 1.875, 1.0));
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.25, 1.0, 0.0, 1.0, 1.6875, 1.0));
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.1875, 0.0, 0.0, 1.0, 0.8125, 1.0));
            }
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        NBTTagCompound compound = new NBTTagCompound();
        ItemStack stack = new ItemStack((Block)this);
        compound.func_74768_a("Game", 0);
        stack.func_77982_d(compound);
        if (tile instanceof TileEntityArcade) {
            TileEntityArcade arcade = (TileEntityArcade)tile;
            compound.func_74768_a("Game", arcade.getGameID());
            stack.func_77982_d(compound);
            return stack;
        }
        return stack;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityArcade) {
            TileEntityArcade arcade = (TileEntityArcade)tile;
            int id = arcade.getGameID();
            return state.func_177226_a((IProperty)GAME, (Comparable)((Object)EnumGame.getValue(id)));
        }
        return state;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, GAME});
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        world.func_175713_t(pos);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()), ArcadeBlocks.INVISIBLE.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)), 3);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        world.func_175698_g(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()));
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        world.func_175698_g(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()));
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        world.func_175698_g(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()));
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta).func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityArcade) {
            TileEntityArcade arcade = (TileEntityArcade)tile;
            if (world.field_72995_K) {
                player.openGui((Object)Arcade.instance, arcade.getGameID(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    @Override
    public String getVariantName(ItemStack stack) {
        if (stack.func_77942_o()) {
            return EnumGame.getRegistryName(stack.func_77978_p().func_74762_e("Game"));
        }
        return EnumGame.getRegistryName(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < 4; ++i) {
            NBTTagCompound compound = new NBTTagCompound();
            ItemStack stack = new ItemStack((Block)this);
            compound.func_74768_a("Game", i);
            stack.func_77982_d(compound);
            list.add((Object)stack);
        }
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int eventId, int eventParam) {
        super.func_189539_a(state, world, pos, eventId, eventParam);
        TileEntity tile = world.func_175625_s(pos);
        return tile != null && tile.func_145842_c(eventId, eventParam);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }
}

