/*
 * Decompiled with CFR 0.152.
 */
package superhb.arcademod.client.model;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import superhb.arcademod.client.ArcadeBlocks;
import superhb.arcademod.client.ArcadeItems;
import superhb.arcademod.client.blocks.BlockArcade;
import superhb.arcademod.client.blocks.BlockPlushie;
import superhb.arcademod.client.items.IItemMeshDefinition;
import superhb.arcademod.util.EnumGame;
import superhb.arcademod.util.EnumMob;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="arcademod")
public class ArcadeModelRegistry {
    public static final ArcadeModelRegistry INSTANCE = new ArcadeModelRegistry();
    private final Set<Item> itemsRegistered = new HashSet<Item>();
    private final StateMapperBase propertyStringMapper = new StateMapperBase(){

        protected ModelResourceLocation func_178132_a(IBlockState state) {
            return new ModelResourceLocation("minecraft:air");
        }
    };

    private ArcadeModelRegistry() {
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        OBJLoader.INSTANCE.addDomain("arcademod");
        INSTANCE.registerBlockModels();
        INSTANCE.registerItemModels();
    }

    private void registerItemModels() {
        this.registerItemModels(ArcadeItems.COIN, ArcadeItems.TICKET);
    }

    private void registerBlockModels() {
        this.registerBlockItemModel(ArcadeBlocks.PRIZE_BOX.func_176223_P());
        this.registerBlockWithVariantAndFacing(ArcadeBlocks.ARCADE_MACHINE.func_176223_P().func_177226_a((IProperty)BlockArcade.GAME, (Comparable)((Object)EnumGame.SNAKE)).func_177226_a((IProperty)BlockArcade.FACING, (Comparable)EnumFacing.NORTH), (IProperty)BlockArcade.GAME, (IProperty)BlockArcade.FACING);
        this.registerBlockWithVariantAndFacing(ArcadeBlocks.PLUSHIE.func_176223_P().func_177226_a((IProperty)BlockPlushie.MOB, (Comparable)((Object)EnumMob.CREEPER)).func_177226_a((IProperty)BlockPlushie.FACING, (Comparable)EnumFacing.NORTH), (IProperty)BlockPlushie.MOB, (IProperty)BlockPlushie.FACING);
    }

    private <T extends Comparable<T>> void registerBlockWithVariantAndFacing(IBlockState state, IProperty<T> property, IProperty<T> facing) {
        for (Comparable values : property.func_177700_c()) {
            for (Comparable face : facing.func_177700_c()) {
                this.registerBlockItemModelVariant(state.func_177226_a(property, values).func_177226_a(facing, face));
            }
        }
    }

    private void registerBlockItemModel(IBlockState state) {
        Item item = Item.func_150898_a((Block)state.func_177230_c());
        this.registerItemModel(item, new ModelResourceLocation(state.func_177230_c().getRegistryName(), "inventory"));
    }

    private void registerBlockItemModelVariant(IBlockState state) {
        Item item = Item.func_150898_a((Block)state.func_177230_c());
        this.registerItemModelVariant(item, new ModelResourceLocation(state.func_177230_c().getRegistryName(), this.propertyStringMapper.func_178131_a((Map)state.func_177228_b())));
    }

    private void registerItemModels(Item ... items) {
        for (Item item : items) {
            this.registerItemModel(item);
        }
    }

    private void registerItemModel(Item item) {
        this.registerItemModel(item, item.getRegistryName().toString());
    }

    private void registerItemModel(Item item, String registryName) {
        this.registerItemModel(item, new ModelResourceLocation(registryName, "inventory"));
    }

    private void registerItemModelVariant(Item item, String variant) {
        this.registerItemModelVariant(item, new ModelResourceLocation(item.getRegistryName(), variant));
    }

    private void registerItemModelVariant(Item item, ModelResourceLocation location) {
        this.itemsRegistered.add(item);
        if (item instanceof IItemMeshDefinition) {
            this.registerItemModel(item, ((IItemMeshDefinition)item).getMeshDefinition());
        }
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{location});
    }

    private void registerItemModel(Item item, ModelResourceLocation location) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)location);
    }

    private void registerItemModel(Item item, ItemMeshDefinition mesh) {
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mesh);
    }
}

