/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.itemborders.config;

import com.anthonyhilyard.itemborders.ItemBorders;
import com.anthonyhilyard.itemborders.util.ColorUtil;
import com.anthonyhilyard.itemborders.util.ItemColor;
import com.anthonyhilyard.itemborders.util.Selectors;
import com.anthonyhilyard.itemborders.util.TextColor;
import com.google.common.collect.Maps;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="itemborders")
public class ItemBordersConfig
extends Configuration {
    public static ItemBordersConfig INSTANCE;
    public boolean hotBar;
    public boolean showForCommon;
    public boolean squareCorners;
    public boolean fullBorder;
    public boolean overItems;
    public boolean extraGlow;
    public boolean automaticBorders;
    public boolean legendaryTooltipsSync;
    private Map<String, List<String>> manualBorders = Maps.newHashMap();
    private Map<ItemKey, Pair<Supplier<Integer>, Supplier<Integer>>> cachedCustomBorders = new HashMap<ItemKey, Pair<Supplier<Integer>, Supplier<Integer>>>();
    private boolean emptyCache = true;

    public static void loadConfig(File file) {
        INSTANCE = new ItemBordersConfig(file);
    }

    public ItemBordersConfig(File file) {
        super(file);
        this.load();
        try {
            Field categoriesField = Configuration.class.getDeclaredField("categories");
            categoriesField.setAccessible(true);
            LinkedHashMap<String, ConfigCategory> categories = new LinkedHashMap<String, ConfigCategory>();
            categories.put("options", this.getCategory("options"));
            categories.put("manual_borders", this.getCategory("manual_borders"));
            categoriesField.set((Object)this, categories);
        }
        catch (Exception e) {
            ItemBorders.LOGGER.error((Object)e);
        }
        this.hotBar = this.getBoolean("hotbar", "options", true, "If the hotbar should display item borders.");
        this.showForCommon = this.getBoolean("show_for_common", "options", false, "If item borders should show for common items.");
        this.squareCorners = this.getBoolean("square_corners", "options", true, "If the borders should have square corners.");
        this.fullBorder = this.getBoolean("full_border", "options", false, "If the borders should fully envelop item slots (otherwise they will only show on the bottom portion of the slot).");
        this.overItems = this.getBoolean("over_items", "options", false, "If the borders draw over items instead of under.");
        this.extraGlow = this.getBoolean("extra_glow", "options", false, "If the borders should have a more prominent glow.");
        this.automaticBorders = this.getBoolean("auto_borders", "options", true, "If automatic borders (based on item rarity) should be enabled.");
        this.legendaryTooltipsSync = this.getBoolean("legendary_tooltips_sync", "options", false, "If enabled and Legendary Tooltips is installed, borders will sync with tooltip border colors.");
        ConfigCategory manualCategory = this.getCategory("manual_borders");
        manualCategory.setComment("Custom border colors for specific items. Selectors supported:\n    Item name - Use item name for vanilla items or include mod name for modded items, supports metadata (requires mod name when specifying metadata).  Examples: minecraft:stick, iron_ore, minecraft:wool:14\n    Tag - $ followed by ore dictionary name.  Examples: $plankWood or $oreIron\n    Mod name - @ followed by mod identifier.  Examples: @spoiledeggs\n    Rarity - ! followed by item's rarity.  This is ONLY vanilla rarities.  Examples: !uncommon, !rare, !epic\n    Display name - % followed by any text.  Will match any item with this text in its tooltip display name.  Case sensitive.  Examples: %[Uncommon]\n    Tooltip text - ^ followed by any text.  Will match any item with this text anywhere in the tooltip text (besides the name).  Case sensitive.\n\nColor can be specified as a minecraft color name or a 6-digit hexadecimal color code.\nUse the following as an example, add one section for each border color you want: \nS:dark_red <\n        minecraft:wool:14\n        $plankWood\n      >\nS:15EDAC <\n        @spoiledeggs\n        !uncommon\n      >");
        for (String color : manualCategory.getValues().keySet()) {
            if (!((Property)manualCategory.getValues().get(color)).isList() || ((Property)manualCategory.getValues().get(color)).getStringList().length <= 0 || ColorUtil.parseColor(color) == null) continue;
            this.manualBorders.put(color, Arrays.asList(((Property)manualCategory.getValues().get(color)).getStringList()));
        }
        this.save();
    }

    @SubscribeEvent
    public static void onLoad(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("itemborders")) {
            ConfigManager.sync((String)"itemborders", (Config.Type)Config.Type.INSTANCE);
            ItemBordersConfig.INSTANCE.emptyCache = true;
        }
    }

    public Pair<Supplier<Integer>, Supplier<Integer>> getBorderColorForItem(ItemStack item) {
        ItemKey itemKey = new ItemKey(item.func_77973_b(), item.func_77960_j(), item.func_77978_p());
        if (this.emptyCache) {
            this.emptyCache = false;
            this.cachedCustomBorders.clear();
        }
        if (this.cachedCustomBorders.containsKey(itemKey)) {
            return this.cachedCustomBorders.get(itemKey);
        }
        for (String key : this.manualBorders.keySet()) {
            Integer color = ColorUtil.parseColor(key);
            Pair colors = Pair.of(() -> color, () -> color);
            if (color == null) continue;
            List<String> value = this.manualBorders.get(key);
            if (value instanceof String) {
                if (!Selectors.itemMatches(item, (String)((Object)value))) continue;
                this.cachedCustomBorders.put(itemKey, (Pair<Supplier<Integer>, Supplier<Integer>>)colors);
                return colors;
            }
            if (!(value instanceof List)) continue;
            List<String> valueList = value;
            for (String stringVal : valueList) {
                if (!(stringVal instanceof String) || !Selectors.itemMatches(item, stringVal)) continue;
                this.cachedCustomBorders.put(itemKey, (Pair<Supplier<Integer>, Supplier<Integer>>)colors);
                return colors;
            }
        }
        Pair colors = null;
        if (ItemBordersConfig.INSTANCE.automaticBorders) {
            Integer color = ItemColor.getColorForItem(item, TextColor.parseColor("white"));
            colors = Pair.of(() -> color, () -> color);
        }
        if (Loader.isModLoaded((String)"legendarytooltips") && ItemBordersConfig.INSTANCE.legendaryTooltipsSync) {
            Pair borderColors = null;
            try {
                borderColors = (Pair)Class.forName("com.anthonyhilyard.itemborders.compat.LegendaryTooltipsHandler").getMethod("getBorderColors", ItemStack.class).invoke(null, item);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (borderColors != null) {
                colors = borderColors;
            }
        }
        this.cachedCustomBorders.put(itemKey, colors);
        return colors;
    }

    private class ItemKey {
        private final Item item;
        private final int metadata;
        private final NBTTagCompound tag;

        public ItemKey(Item item, int metadata, NBTTagCompound tag) {
            this.item = item;
            this.metadata = metadata;
            this.tag = tag;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ItemKey itemKey = (ItemKey)obj;
            return Objects.equals(this.item, itemKey.item) && Objects.equals(this.metadata, itemKey.metadata) && Objects.equals(this.tag, itemKey.tag);
        }

        public int hashCode() {
            return Objects.hash(this.item, this.metadata, this.tag);
        }
    }
}

