/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.app;

import com.jediterm.terminal.model.hyperlinks.HyperlinkFilter;
import com.jediterm.terminal.model.hyperlinks.LinkInfo;
import com.jediterm.terminal.model.hyperlinks.LinkResult;
import com.jediterm.terminal.model.hyperlinks.LinkResultItem;
import java.awt.Desktop;
import java.net.URI;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlFilter
implements HyperlinkFilter {
    private static final Pattern URL_PATTERN = Pattern.compile("\\b(mailto:|(news|(ht|f)tp(s?))://|((?<![\\p{L}0-9_.])(www\\.)))[-A-Za-z0-9+$&@#/%?=~_|!:,.;]*[-A-Za-z0-9+$&@#/%=~_|]");

    public static boolean canContainUrl(@NotNull String line) {
        return line.contains("mailto:") || line.contains("://") || line.contains("www.");
    }

    @Override
    @Nullable
    public LinkResult apply(String line) {
        if (!UrlFilter.canContainUrl(line)) {
            return null;
        }
        int textStartOffset = 0;
        Matcher m = URL_PATTERN.matcher(line);
        LinkResultItem item = null;
        ArrayList<LinkResultItem> items = null;
        while (m.find()) {
            if (item != null && items == null) {
                items = new ArrayList<LinkResultItem>(2);
                items.add(item);
            }
            String url = m.group();
            item = new LinkResultItem(textStartOffset + m.start(), textStartOffset + m.end(), new LinkInfo(() -> {
                try {
                    Desktop.getDesktop().browse(new URI(url));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }));
            if (items == null) continue;
            items.add(item);
        }
        return items != null ? new LinkResult(items) : (item != null ? new LinkResult(item) : null);
    }
}

